// ======== ======== ======== ======== ======== ======== ======== ========
//
//	title : classMake[ sceneSkyDome.cpp ]		Auter : KENSUKE WATANABE
//														Data  : 2017/04/27
//
// -------- -------- -------- -------- -------- -------- -------- --------
//Update : 2017/04/27
//
// ======== ======== ======== ======== ======== ======== ======== ========
// -------- -------- -------- -------- -------- -------- -------- --------
// CN[ht@C
// -------- -------- -------- -------- -------- -------- -------- --------
#include <math.h>
#include "main.h"
#include "sceneSkydome.h"
#include "input.h"
#include "manager.h"
#include "texManager.h"
#include "renderer.h"

// ======== ======== ======== ======== ======== ======== ======== ========
// 
// -------- -------- -------- -------- -------- -------- -------- --------
void CSceneSkydome::Init( void )
{
	// 
	SetPos(D3DXVECTOR3(0.f, 0.f, 0.f));
	SetRot(D3DXVECTOR3(0.f, 0.f, 0.f));
	SetScl(D3DXVECTOR3(1.f, 1.f, 1.f));
	m_move = D3DXVECTOR3(0.f, 0.f, 0.f);
	m_moveTex = 0.0001f;
	m_numVtx = 0;
	m_numIndex = 0;
	m_strFilePass.clear();

	// _ݒ菈
	SetVtx(CRenderer::GetDevice(), 32, 32);
}

//-----------------------------------------------------------------------------
// I
//-----------------------------------------------------------------------------
void CSceneSkydome::Uninit( void )
{
	// CfbNXobt@̉
	if(m_pIdxBuffer != nullptr)
	{
		m_pIdxBuffer->Release();
		m_pIdxBuffer = nullptr;
	}

	// eNX̏I
	CScene3D::Uninit();
}

// ======== ======== ======== ======== ======== ======== ======== ========
// XV
// -------- -------- -------- -------- -------- -------- -------- --------
void CSceneSkydome::Update( void )
{
	AddRot(D3DXVECTOR3(0.f, m_moveTex, 0.f));
}

// ======== ======== ======== ======== ======== ======== ======== ========
// |S`
// -------- -------- -------- -------- -------- -------- -------- --------
void CSceneSkydome::Draw( void )
{
	// foCX̎擾
	LPDIRECT3DDEVICE9 pDevice = CRenderer::GetDevice();

	D3DXVECTOR3 pos = GetPos();
	D3DXVECTOR3 rot = GetRot();
	D3DXVECTOR3 scl = GetScl();

	// [h}gNX̍쐬
	D3DXMATRIX mtxScl;						// gs
	D3DXMATRIX mtxRot;						// ]s
	D3DXMATRIX mtxPos;						// ss

	D3DXMatrixIdentity(&m_mtxWorld);		// sPʍsɂ( g嗦1,0ŏ )
	D3DXMatrixIdentity(&mtxScl);			// 
	D3DXMatrixIdentity(&mtxRot);			// 
	D3DXMatrixIdentity(&mtxPos);			// 

	// [hϊsݒ肵ĕϊ
	D3DXMatrixScaling(&mtxScl, scl.x, scl.y, scl.z);				// gs
	D3DXMatrixRotationYawPitchRoll(&mtxRot, rot.y, rot.x, rot.z);	// ]s
	D3DXMatrixTranslation(&mtxPos, pos.x, pos.y, pos.z);			// ss

	D3DXMatrixMultiply(&m_mtxWorld, &m_mtxWorld, &mtxScl);
	D3DXMatrixMultiply(&m_mtxWorld, &m_mtxWorld, &mtxRot);
	D3DXMatrixMultiply(&m_mtxWorld, &m_mtxWorld, &mtxPos);

	pDevice->SetRenderState(D3DRS_LIGHTING, FALSE);			// Cg\It

	// foCXɃ[hϊsݒ
	pDevice->SetTransform(D3DTS_WORLD, &m_mtxWorld);

	// _tH[}bg̐ݒ
	pDevice->SetFVF(FVF_VERTEX_3D);

	// CfbNXԍfoCXɐݒ
	pDevice->SetIndices(m_pIdxBuffer);

	// eNX`pCvCɃZbg
	if(!m_strFilePass.empty())
	{
		pDevice->SetTexture(0, CManager::GetTexManager()->GetTexInterface(m_strFilePass));
	}else {pDevice->SetTexture(0, nullptr);}

	// _obt@foCX̃f[^ Xg[ɃoCh
	pDevice->SetStreamSource(0, m_pVtxBuffer, 0, sizeof(VERTEX_3D));

	pDevice->DrawIndexedPrimitive(D3DPT_TRIANGLESTRIP, 0, 0, NUM_POLYGON, 0, m_numIndex - 2);

	// _[Xe[g̐ݒ߂
	pDevice->SetRenderState(D3DRS_LIGHTING, TRUE);			// Cg̕\Lɂ
}

//-----------------------------------------------------------------------------
// _쐬
//-----------------------------------------------------------------------------
HRESULT CSceneSkydome::SetVtx(LPDIRECT3DDEVICE9 pDevice, int slices, int stacks)
{
	float phi =	(D3DX_PI * 2) / stacks;		// ӂ̊px
	float theta = (D3DX_PI * 2) / slices;	// Ƃ̊px

	slices /= 2;

	m_numVtx = (int)((slices) + 1) * (stacks + 1);					// _
	m_numIndex = (2 + 2 * stacks) * (slices) + ((slices) - 1) * 2;	// CfbNX(|S`掞ɕKvȒ_)

	// _obt@쐬--------------------------------
	if(FAILED(pDevice->CreateVertexBuffer(sizeof(VERTEX_3D) * m_numVtx,
		D3DUSAGE_WRITEONLY, FVF_VERTEX_3D, D3DPOOL_MANAGED, &m_pVtxBuffer, nullptr)))
	{
		return E_FAIL;
	}
	VERTEX_3D* pVtx;	// obt@bN
	m_pVtxBuffer->Lock(0, 0, (void**)&pVtx, 0);

	// _̐ݒ
	float x, y, z;
	for(int cntSlices = 0; cntSlices <= slices; cntSlices++)
	{
		for(int cntStacks = 0; cntStacks <= stacks; cntStacks++)
		{
			// W
			x = cos(theta * (slices - cntSlices)) * sin(phi * cntStacks);	// X
			y = sin(theta * (slices - cntSlices));							// Y
			z = cos(theta * (slices - cntSlices)) * cos(phi * cntStacks);	// Z
			pVtx[0].pos = D3DXVECTOR3(x, y, z);
			// @
			pVtx[0].nom = D3DXVECTOR3(0.f, 0.f, -1.f);
			// F
			pVtx[0].col = D3DCOLOR_RGBA(255, 255, 255, 255);
			// eNX`W
			pVtx[0].tex = D3DXVECTOR2((0.5f / stacks) * cntStacks, (2.f / slices) * cntSlices);
			pVtx++;
		}
	}
	// bN̉
	m_pVtxBuffer->Unlock();

	// CfbNXobt@쐬--------------------------------
	if(FAILED(pDevice->CreateIndexBuffer(
		sizeof(WORD) * m_numIndex,			// obt@
		D3DUSAGE_WRITEONLY,					// gptO
		D3DFMT_INDEX16,						// Kvȃobt@
		D3DPOOL_MANAGED,					// ̊Ǘ@
		&m_pIdxBuffer,
		nullptr)))
	{
		return E_FAIL;
	}

	WORD *pIdx;			// obt@bN
	m_pIdxBuffer->Lock(0, 0, (void**)&pIdx, 0);

	int nCnt = 0;
	for (int nCntY = 0; nCntY < slices; nCntY++)
	{
		if (nCntY != 0)	// ԏ߂Ȃ
		{
			// _ł
			pIdx[nCnt] = static_cast<WORD>((stacks + 1) * nCntY + (stacks + 1));
			nCnt++;
		}
		// 2_ł(O, )
		pIdx[nCnt] = static_cast<WORD>((stacks + 1) * (nCntY + 1));
		nCnt++;
		pIdx[nCnt] = static_cast<WORD>((stacks + 1) * nCntY);
		nCnt++;

		for (int nCntX = 0; nCntX < stacks; nCntX++)
		{
			// 2_ł(O, )
			pIdx[nCnt] = static_cast<WORD>(((stacks + 1) * (nCntY + 1)) + (nCntX + 1));
			nCnt++;
			pIdx[nCnt] = static_cast<WORD>((stacks + 1) * nCntY + (nCntX + 1));
			nCnt++;
		}
		if (nCntY != slices - 1)	// ŌザȂ
		{
			// _ł
			pIdx[nCnt] = static_cast<WORD>(stacks + (nCntY * (stacks + 1)));
			nCnt++;
		}
	}

	//bN̉
	m_pIdxBuffer->Unlock();

	return NOERROR;
}

// -------- -------- -------- -------- -------- -------- -------- --------
// 쐬
// -------- -------- -------- -------- -------- -------- -------- --------
CSceneSkydome *CSceneSkydome::Create(const D3DXVECTOR3 &pos, const D3DXVECTOR3 &rot, const D3DXVECTOR3 &scl, const std::string &strFilePass)
{
	// CSceneSkydome̐
	CSceneSkydome *pSceneSkydome;
	pSceneSkydome = new CSceneSkydome();
	pSceneSkydome->Init();

	pSceneSkydome->SetPos(pos);
	pSceneSkydome->SetRot(rot);
	pSceneSkydome->SetScl(scl);
	pSceneSkydome->m_strFilePass = strFilePass;
	
	// eNX`̃Zbg
	CManager::GetTexManager()->SetTex(strFilePass);

	return pSceneSkydome;
}